//====================================================
//Name :  		DW_storet.js
//Author:   		Joseph Wilson/Christine Tsang/Thieu Nguyen/Ganesh Thadkamalla/Blythe Norris
//Creation Date:  	11/27/2002
//Last Revised Date:  	3/04/2003 --revised JS for new CHAR section for NS
//			4/02/2003 --revised passback and openwin for External Ref lookup. -C Tsang
//			4/08/2003 --added date check functions -J Wilson
//			4/11/2003 --revised addStationsToList and openwin. -C Tsang
//			4/14/2003 --revised addCharAliasToList, ChangeOptionDays, and daysInMonth. -J Wilson
//			4/21/2003 --added escape function when passing user entered strings. -J Wilson
//                      4/24/2003 --revised dateRangeValidate() so it works on Netscape 4.7 -T Nguyen
//			5/01/2003 --created seperate station and result submit criteria functions for geo pages -J Wilson
//                      5/01/2003 --revised alerts for consistency. -C Tsang
//			5/23/2003 --updated ChangeOptionDays to avoid resetting to -- values; added completeDateValidate -J Wilson
//			6/02/2003 --added textTrim function and expanded lat/long validation to capture blank text -J Wilson
//                      8/11/2003 --updated External Ref Scheme error msg text. -C Tsang 
//			8/22/2003 --reduced Characteristic selection limit to 50 and updated alert msg -JW
//			6/21/2004 --added submitCriteriaStationSTN function -JW
//			7/28/2004 --added org to stn-ids passed from station selection lists -JW
//			7/30/2004 --adjusted add char alias and add stn to list procs to account for title rows in counts -JW
//Description:  This script has a list of javascript functions that will be used by
//		the STORET Central Warehouse web interface.
//=====================================================
//
//======================================================
// Function Name : passback()  Author : Joseph Wilson
//==========================================================
//this function handles communication between the popup windows and the Station 
//Selection Criteria page
function passback (popup_name) {
// sends one or more selected counties back to the Station Selection Criteria form.
if (popup_name=="COUNTY") {
	var srcList = document.select_county.as_county;
	var len = srcList.length;
	var county_list ="";
	var county_codes ="";
	if (srcList.options[0].selected) {
		opener.document.forms[1].as_county.value = 'ALL';
		opener.document.forms[1].v_county_code.value = 'ALL';
		close();
		}
	else {
		for(var i = 0; i < srcList.length; i++) {
			if ((srcList.options[i] != null) && (srcList.options[i].selected)) {
				county_list = county_list+srcList.options[i].text+", "; 
				county_codes = county_codes+srcList.options[i].value+",";
	     			}
			}
		opener.document.forms[1].as_county.value = county_list.substring(0,county_list.length-2);
		opener.document.forms[1].v_county_code.value = county_codes.substring(0,county_codes.length-1);
		close();
		}
	}
// sends the list of characteristics back to the Station Selection Criteria form for processing.
if (popup_name=="CHAR") {
	var index=document.select_char.as_char.selectedIndex;
	if (index == -1) {
		close();
		}
	else {
		self.opener.addCharsToList(window.document.forms[0].as_char);
		close();
		}
	}
if (popup_name=="CHAR_ALIAS") {
	var index=document.select_char.as_char.selectedIndex;
	if (index == -1) {
		close();
		}
	else {
		self.opener.addAliasCharsToList(window.document.forms[0].as_char);
		close();
		}
	}
// sends a single HUC code back to the Station Selection Criteria form.
if (popup_name=="HUC") {
	var index=document.forms[0].as_huc.selectedIndex;
	if (index == -1) {
		close();
		}
	else {
		opener.document.forms[1].as_huc.value=document.forms[0].as_huc.options[index].value;
		close();
		}
	}
//proj
if (popup_name=="PROJ") {
	var index=document.forms[0].D_PROJ_LIST.selectedIndex;
	if (index == -1) {
		close();
		}
	else {
		if (index > 1) {
			opener.document.forms[1].as_proj.value=document.forms[0].D_PROJ_LIST.options[index].text.substring(16,76);
			opener.document.forms[1].D_PROJ_LIST.value=document.forms[0].D_PROJ_LIST.options[index].value;
			}
		close();
		}
	}
if (popup_name=="STATION") {
	var index=document.select_stations.d_station_list.selectedIndex;
	if (index == -1) {
		close();
		}
	else {
		self.opener.addStationsToList(window.document.forms[0].d_station_list);
		close();
		}
	}
// sends an External Ref Scheme code back to the form.
if (popup_name=="EXTREF") {
	var index=document.forms[0].D_EXTREF_LIST.selectedIndex;
//	var extlist = window.document.forms[0].D_EXTREF_LIST;
//	var val=extlist.options[index].value;
	if (index == -1) {
		close();
		}
	else {
		if (index > 1) {
			opener.document.forms[1].as_extref.value=document.forms[0].D_EXTREF_LIST.options[index].text.substring(0,8);
			opener.document.forms[1].D_EXTREF_LIST.value=document.forms[0].D_EXTREF_LIST.options[index].value;
			}
		close();
		}
	}
}
//======================================================
// Function Name : syncElements()  Author : Joseph Wilson
//==========================================================
//ensures loc_pt and pt_seq are selected and un-selected together
function syncElements(selected) {
if (selected=="loc_pt") {
	if (document.forms[1].v_Columns[8].checked==true) {
		document.forms[1].v_Columns[9].checked=true;
		}
	else {
		document.forms[1].v_Columns[9].checked=false;
		}
	}
if (selected=="pt_seq") {
	if (document.forms[1].v_Columns[9].checked==true) {
		document.forms[1].v_Columns[8].checked=true;
		}
	else {
		document.forms[1].v_Columns[8].checked=false;
		}
	}
}
//======================================================
// Function Name : testListCount()  Author : Joseph Wilson
//==========================================================
//currently disabled. may be implemented at a later date
function testListCount() {
if (document.forms[1].v_StationCount.value>100) {
	alert ('Too many stations to produce a station list. Station lists cannot include more than 100 stations. Please refine your search criteria and try again'); 
	document.forms[1].report_type[0].checked=true;
	}
}
//======================================================
// Function Name : longReport()  Author : Joseph Wilson
//==========================================================
//selects all report elements
function longReport() {
for (var x = 0; x < document.forms[1].v_Columns.length; x++) {
	document.forms[1].v_Columns[x].checked=true;
	}
}
//======================================================
// Function Name : shortReport()  Author : Joseph Wilson
//==========================================================
//selects all default report elements
function shortReport() {
for (var x = 0; x < document.forms[1].v_Columns.length; x++) {
	document.forms[1].v_Columns[x].checked=false;
	}
document.forms[1].v_Columns[0].checked=true;
document.forms[1].v_Columns[1].checked=true;
document.forms[1].v_Columns[2].checked=true;
document.forms[1].v_Columns[4].checked=true;
document.forms[1].v_Columns[10].checked=true;
document.forms[1].v_Columns[11].checked=true;
document.forms[1].v_Columns[12].checked=true;
document.forms[1].v_Columns[13].checked=true;
document.forms[1].v_Columns[18].checked=true;
document.forms[1].v_Columns[20].checked=true;
document.forms[1].v_Columns[21].checked=true;
document.forms[1].v_Columns[23].checked=true;
document.forms[1].v_Columns[25].checked=true;
document.forms[1].v_Columns[27].checked=true;
document.forms[1].v_Columns[31].checked=true;
document.forms[1].v_Columns[32].checked=true;
document.forms[1].v_Columns[39].checked=true;
}
//======================================================
// Function Name : clearReport()  Author : Joseph Wilson
//==========================================================
//clears all report elements
function clearReport() {
for (var x = 0; x < document.forms[1].v_Columns.length; x++) {
	document.forms[1].v_Columns[x].checked=false;
	}
}
//======================================================
// Function Name : submitReport()  Author : Joseph Wilson
//==========================================================
//ensures that at least one report element is selected
function submitReport() {
var blank = true;
for (var x = 0; x < document.forms[1].v_Columns.length; x++) {
	if (document.forms[1].v_Columns[x].checked==true) {
		blank = false;
		break;
		}
	}
if (blank==true) {
	alert ('Please select at least one report element.');
	}
else {
	document.forms[1].submit();
	}
}
//======================================================
// Function Name : submitCriteria()  Author : Joseph Wilson
//==========================================================
//selects all valid chars from the char list and valides lat-long values
function submitCriteria() {
sourceList = window.document.forms[1].char_list;
sourceList.options[0].selected = false;
document.forms[1].v_char_names.value = "";
for(var i = 1; i < sourceList.options.length; i++) {
	if (sourceList.options[i] != null) {
		sourceList.options[i].selected = true;
		if (i != 1) {
			document.forms[1].v_char_names.value = document.forms[1].v_char_names.value + sourceList.options[i].text + "<br>";
		}
	}
}
document.forms[1].taxon_filter.checked=true;
if(isNaN(document.forms[1].MAX_LAT_DD.value)) {
	alert('Latitude and Longitude values must be valid numbers.');
	}
else if(isNaN(document.forms[1].MIN_LAT_DD.value)) {
	alert('Latitude and Longitude values must be valid numbers.');
	}
else if(isNaN(document.forms[1].MAX_LONG_DD.value)) {
	alert('Latitude and Longitude values must be valid numbers.');
	}
else if(isNaN(document.forms[1].MIN_LONG_DD.value)) {
	alert('Latitude and Longitude values must be valid numbers.');
	}
else if(Math.abs(document.forms[1].MAX_LAT_DD.value) > 90 || Math.abs(document.forms[1].MIN_LAT_DD.value) > 90){
	alert('The absolute value of Latitude must be less than or equal to 90.')
        }
else if(Math.abs(document.forms[1].MAX_LONG_DD.value) > 180 || Math.abs(document.forms[1].MIN_LONG_DD.value) > 180){
	alert('The absolute value of Longitude must be less than or equal to 180.')
        }
else {
	document.forms[1].target="_new";
	document.forms[1].submit();
	}
}
//======================================================
// Function Name : submitCriteriaStationSTN()  Author : Joseph Wilson
//==========================================================
//selects all valid chars from the char list and valides lat-long values
function submitCriteriaStationSTN() {
sourceList = window.document.forms[1].char_list;
sourceList.options[0].selected = false;
document.forms[1].v_char_names.value = "";
for(var i = 1; i < sourceList.options.length; i++) {
	if (sourceList.options[i] != null) {
		sourceList.options[i].selected = true;
		if (i != 1) {
			document.forms[1].v_char_names.value = document.forms[1].v_char_names.value + sourceList.options[i].text + "<br>";
		}
	}
}
sourceList = window.document.forms[1].station_list;
sourceList.options[0].selected = false;
document.forms[1].v_station_names.value = "";
for(var i = 1; i < sourceList.options.length; i++) {
	if (sourceList.options[i] != null) {
		sourceList.options[i].selected = true;
		if (i != 1) {
			document.forms[1].v_station_names.value = document.forms[1].v_station_names.value + sourceList.options[i].text.substring(0,25) + "<br>";
		}
	}
}
document.forms[1].taxon_filter.checked=true;
document.forms[1].target="_new";
document.forms[1].submit();
}
//======================================================
// Function Name : trimText()  Author : Joseph Wilson
//==========================================================
//trims trailing blank spaces
function trimText(vText) {
while(''+vText.value.charAt(vText.value.length-1)==' ')vText.value=vText.value.substring(0,vText.value.length-1);
}
//======================================================
// Function Name : submitCriteriaResultGeo()  Author : Joseph Wilson
//==========================================================
//selects all valid chars from the char list and validates lat-long values
function submitCriteriaResultGeo() {
sourceList = window.document.forms[1].char_list;
sourceList.options[0].selected = false;
document.forms[1].v_char_names.value = "";
for(var i = 1; i < sourceList.options.length; i++) {
	if (sourceList.options[i] != null) {
		sourceList.options[i].selected = true;
		if (i != 1) {
			document.forms[1].v_char_names.value = document.forms[1].v_char_names.value + sourceList.options[i].text + "<br>";
		}
	}
}
document.forms[1].taxon_filter.checked=true;
trimText(document.forms[1].MAX_LAT_DD);
trimText(document.forms[1].MIN_LAT_DD);
trimText(document.forms[1].MAX_LONG_DD);
trimText(document.forms[1].MIN_LONG_DD);
if(isNaN(document.forms[1].MAX_LAT_DD.value) || document.forms[1].MAX_LAT_DD.value=="") {
	alert('Latitude and Longitude values must be valid numbers.');
	}
else if(isNaN(document.forms[1].MIN_LAT_DD.value)|| document.forms[1].MIN_LAT_DD.value=="") {
	alert('Latitude and Longitude values must be valid numbers.');
	}
else if(isNaN(document.forms[1].MAX_LONG_DD.value)|| document.forms[1].MAX_LONG_DD.value=="") {
	alert('Latitude and Longitude values must be valid numbers.');
	}
else if(isNaN(document.forms[1].MIN_LONG_DD.value) || document.forms[1].MIN_LONG_DD.value=="") {
	alert('Latitude and Longitude values must be valid numbers.');
	}
else if(Math.abs(document.forms[1].MAX_LAT_DD.value) > 90 || Math.abs(document.forms[1].MIN_LAT_DD.value) > 90){
	alert('The absolute value of Latitude must be less than or equal to 90.')
        }
else if(Math.abs(document.forms[1].MAX_LONG_DD.value) > 180 || Math.abs(document.forms[1].MIN_LONG_DD.value) > 180){
	alert('The absolute value of Longitude must be less than or equal to 180.')
        }
else {  
      if(dateRangeValidate()&&completeDateValidate()){
	document.forms[1].target="_new";
	document.forms[1].submit();
	}
        }
}
//======================================================
// Function Name : submitCriteria2()  Author : Joseph Wilson
//==========================================================
//selects all valid chars from the char list 
function submitCriteria2() {
sourceList = window.document.forms[1].char_list;
sourceList.options[0].selected = false;
document.forms[1].v_char_names.value = "";
for(var i = 1; i < sourceList.options.length; i++) {
	if (sourceList.options[i] != null) {
		sourceList.options[i].selected = true;
		if (i != 1) {
			document.forms[1].v_char_names.value = document.forms[1].v_char_names.value + sourceList.options[i].text + "<br>";
		}
	}
}
if(dateRangeValidate()&&completeDateValidate()){
document.forms[1].taxon_filter.checked=true;
document.forms[1].target="_new";
document.forms[1].submit();
}
}
//======================================================
// Function Name : submitCriteria3()  Author : Joseph Wilson
//==========================================================
//selects all valid stations from the station list 
function submitCriteria3() {
sourceList = window.document.forms[1].station_list;
sourceList.options[0].selected = false;
document.forms[1].v_station_names.value = "";
for(var i = 1; i < sourceList.options.length; i++) {
	if (sourceList.options[i] != null) {
		sourceList.options[i].selected = true;
		if (i != 1) {
			document.forms[1].v_station_names.value = document.forms[1].v_station_names.value + sourceList.options[i].text.substring(8,25) + "<br>";
		}
	}
}
//selects all valid char from char list
sourceList = window.document.forms[1].char_list;
sourceList.options[0].selected = false;
document.forms[1].v_char_names.value = "";
for(var i = 1; i < sourceList.options.length; i++) {
	if (sourceList.options[i] != null) {
		sourceList.options[i].selected = true;
		if (i != 1) {
			document.forms[1].v_char_names.value = document.forms[1].v_char_names.value + sourceList.options[i].text + "<br>";
		}
	}
}
if(dateRangeValidate()&&completeDateValidate()){
document.forms[1].taxon_filter.checked=true;
document.forms[1].target="_new";
document.forms[1].submit();
}
}
//======================================================
// Function Name : addAliasCharsToList()  Author : Joseph Wilson
//==========================================================
// Add the selected items from the char search window to the selected char list
function addAliasCharsToList(sourceList) {
	destList = window.document.forms[1].char_list;
	srcList = sourceList;
	var len = destList.length;
	var totalChars = len;
		for(var i = 2; (i < srcList.length) && (totalChars <=52);
i++) {
			if ((srcList.options[i] != null) && (srcList.options[i].selected)) {
			//Check if this value already exist in the destList or not
			//if not then add it otherwise do not add it. check using char PK
		totalChars++;
		if (totalChars <= 52) {
			var found = false;
			for(var count = 0; count < len; count++) {
				if (destList.options[count] != null) {
					if (srcList.options[i].value == destList.options[count].value) {
						found = true;
						break;
				      }
				}
			}
			if (found != true) {
				//only add display_name to the selected chars list (not the alias name)
				destList.options[len] = new Option(srcList.options[i].text.substring(0,60));
				destList.options[len].value = srcList.options[i].value;
				len++;
         			}
     			}
		else {
			alert('You have exceeded the 50 Characteristics limit.  Please reduce your number of selections and try again.');
		}
   		}
	}
}
//======================================================
// Function Name : addCharsToList()  Author : Joseph Wilson
//==========================================================
// Add the selected items from the char search window to the selected char list
function addCharsToList(sourceList) {
	destList = window.document.forms[1].char_list;
	srcList = sourceList;
	var len = destList.length;
	for(var i = 0; i < srcList.length; i++) {
		if ((srcList.options[i] != null) && (srcList.options[i].selected)) {
		//Check if this value already exist in the destList or not
		//if not then add it otherwise do not add it.
		var found = false;
		for(var count = 0; count < len; count++) {
			if (destList.options[count] != null) {
				if (srcList.options[i].text == destList.options[count].text) {
					found = true;
					break;
			      }
			}
		}
		if (found != true) {
			destList.options[len] = new Option(srcList.options[i].text);
			destList.options[len].value = srcList.options[i].value;
			len++;
         		}
      		}
   	}
}
//======================================================
// Function Name : addStationsToList()  Author : Joseph Wilson
//==========================================================
// Add the selected items from the station search window to the selected station list
function addStationsToList(sourceList) {
	destList = window.document.forms[1].station_list;
	srcList = sourceList;
	var len = destList.length;
	var totalStations = len;
		for(var i = 2; (i < srcList.length) && (totalStations <=102); i++) {
			if ((srcList.options[i] != null) && (srcList.options[i].selected)) {
			//Check if this value already exist in the destList or not
			//if not then add it otherwise do not add it. check using station PK
		totalStations++;
		if (totalStations <= 102) {
			var found = false;
			for(var count = 2; count < len; count++) {
				if (destList.options[count] != null) {
					if (srcList.options[i].value == destList.options[count].value) {
						found = true;
						break;
				      }
				}
			}
			if (found != true) {
				destList.options[len] = new Option(srcList.options[i].text);
				destList.options[len].value = srcList.options[i].value;
				len++;
         			}
     			}
		else {
			alert('You have exceeded the 100 Stations limit.  Please reduce your number of selections and try again.');
		}
   		}
	}
}
//======================================================
// Function Name : deleteSelectedFromCharList()  Author : Joseph Wilson
//==========================================================
// Deletes selected chars from the characteristic list.
function deleteSelectedFromCharList() {
var destList  = window.document.forms[1].char_list;
var len = destList.options.length;
	for(var i = (len-1); i >= 2; i--) {
		if ((destList.options[i] != null) && (destList.options[i].selected == true)) {
			destList.options[i] = null;
	      }
   	}
}
//======================================================
// Function Name :  deleteAllFromCharList()  Author : Joseph Wilson
//==========================================================
// Deletes all chars from the characteristic list.
function deleteAllFromCharList () {
var destList  = window.document.forms[1].char_list;
var len = destList.options.length;
	for(var i = (len-1); i >= 2; i--) {
		destList.options[i] = null;
   	}
}
//======================================================
// Function Name : deleteSelectedFromStationList()  Author : Joseph Wilson
//==========================================================
// Deletes selected chars from the characteristic list.
function deleteSelectedFromStationList() {
var destList  = window.document.forms[1].station_list;
var len = destList.options.length;
	for(var i = (len-1); i >= 2; i--) {
		if ((destList.options[i] != null) && (destList.options[i].selected == true)) {
			destList.options[i] = null;
	      }
   	}
}
//======================================================
// Function Name :  deleteAllFromStationList()  Author : Joseph Wilson
//==========================================================
// Deletes all chars from the characteristic list.
function deleteAllFromStationList () {
var destList  = window.document.forms[1].station_list;
var len = destList.options.length;
	for(var i = (len-1); i >= 2; i--) {
		destList.options[i] = null;
   	}
}
//======================================================
// Function Name :  openWin()  Author : Joseph Wilson
//==========================================================
// The openWin function pops up a small windows for getting additional information.
function openWin(type) {
   if (type=="state") {
	var ls_index=document.forms[1].as_state.selectedIndex;
	document.forms[1].geographic[0].checked=true;
	document.forms[1].as_huc.value='ALL';
	if (ls_index==0) {
		alert('Please select a State before performing a County lookup.');
		}
	else {
		var v_state= "DW_COUNTY_POPUP?v_StateCode="+document.forms[1].as_state.options[ls_index].value;
  		myWinCounty= open(v_state, "County_window", "width=500,height=300,status=yes,toolbar=no,menubar=yes,scrollbars=yes,location=yes");
		}
	}
   if (type=="char_alias") {
	var selected_char_type = document.forms[1].as_char_alias_type.options[document.forms[1].as_char_alias_type.selectedIndex].value;
	var search_string = escape(document.forms[1].as_char.value);
	if (document.forms[1].as_char.value=="") {
		alert('Please enter a Characteristic Search string.');
		document.forms[1].as_char.focus();
		}
	else {
		if (document.forms[1].taxon_filter.checked==true) {
			var v_char = "DW_CHAR_ALIAS_POPUP?v_CharString="+search_string+"&taxon_filter=ON&as_char_alias_type="+selected_char_type;
		}
		else {
			var v_char = "DW_CHAR_ALIAS_POPUP?v_CharString="+search_string+"&taxon_filter=OFF&as_char_alias_type="+selected_char_type;
		}
		myWinHuc = open(v_char, "Characteristics","width=950,height=350,status=yes,toolbar=no,menubar=yes,scrollbars=yes,location=yes");
		}
	}
   if (type=="char") {
	document.forms[1].characteristic[1].checked=true;
	if (document.forms[1].as_char.value=="") {
		alert('Please enter a Characteristic Search string.');
		document.forms[1].as_char.focus();
	}
	else {
		if (document.forms[1].taxon_filter.checked==true) {
			var v_char = "DW_CHAR_POPUP?v_CharString="+document.forms[1].as_char.value+"&taxon_filter=ON";
		}
		else {
			var v_char = "DW_CHAR_POPUP?v_CharString="+document.forms[1].as_char.value+"&taxon_filter=OFF";
		}
		myWinHuc = open(v_char, "Characteristics","width=600,height=350,status=yes,toolbar=no,menubar=yes,scrollbars=yes,location=yes");
		}
	}
   if (type=="huc") {
		var v_huc = "DW_HUC_POPUP";
		document.forms[1].geographic[2].checked=true;
		document.forms[1].as_state.options[0].selected=true;
		document.forms[1].as_county.value='ALL';
		myWinHuc = open(v_huc, "HUC","width=600,height=350,status=yes,toolbar=no,menubar=yes,scrollbars=yes,location=yes");
	}
   if (type=="proj") {
	var ls_index=document.forms[1].D_ORG_LIST.selectedIndex;
	if (ls_index==0) {
		alert('Please select an Organization before performing a Project lookup.');
		}
	else {
		var v_proj = "DW_PROJ_POPUP?v_org="+document.forms[1].D_ORG_LIST.options[ls_index].value;
		myWinHuc = open(v_proj, "Project","width=700,height=350,status=yes,toolbar=no,menubar=yes,scrollbars=yes,location=yes");
		}
	}
   if (type=="station") {
	var ls_index=document.forms[1].D_ORG_LIST.selectedIndex;
	if (ls_index==0) {
		alert('Please select an Organization before performing a Station lookup.');
		}
	else {
		if (document.forms[1].as_station.value=="") {
			alert('Please enter a Station Search string.');
			document.forms[1].as_station.focus();
			}
		else {
    			var selectedSearch = "ID";   
			for (var i=0; i < 3; i++) {
			      if (document.forms[1].searchtype[i].checked) {
	         			selectedSearch = document.forms[1].searchtype[i].value;
					break;
				      }
			   }
			var v_station = "DW_STATION_POPUP?v_StationString="+escape(document.forms[1].as_station.value)+"&v_org="+document.forms[1].D_ORG_LIST.options[ls_index].value+
                           "&v_searchtype="+selectedSearch+"&v_extref="+document.forms[1].as_extref.value;
			myWinHuc = open(v_station, "Station","width=950,height=350,status=yes,toolbar=no,menubar=yes,scrollbars=yes,location=yes");
		}	}
	}
   if (type=="extref") {
	var ls_index=document.forms[1].D_ORG_LIST.selectedIndex;
	if (ls_index==0) {
		alert('Please select an Organization before performing a Station Alias Type lookup.');
		}
	else {
	
		var v_extref = "DW_EXTREF_POPUP?v_org="+document.forms[1].D_ORG_LIST.options[ls_index].value;
		myWinHuc = open(v_extref, "ExtRef","width=750,height=350,status=yes,toolbar=no,menubar=yes,scrollbars=yes,location=yes");
		}
        }
}
//================================================================================
// Function Name : openHelp()			Author : Ganesh Thadkamalla
//================================================================================
function openHelp(label_name)
{
  win1= window.open(label_name,"STORET_help","scrollbars=1,resizable=1,locationbar=0,menubar=0,width=600,height=300");
  // netscape browsers.
  if (navigator.appName.substring(0,8) == "Netscape")
  { win1.focus();
  }
  //microsoft browsers
  if (navigator.appName.substring(0,9) == "Microsoft")
  {
    msiestart = (navigator.appVersion.indexOf('(') + 1);
    msieend = navigator.appVersion.indexOf(')');
    msiestring=navigator.appVersion.substring(msiestart,msieend);
    msiearray = msiestring.split(";");
    platform = msiearray[2];
    msieversion = msiearray[1].split(" ");
    version = msieversion[2];
    //focus only if msie version > 4
    if(version.substring(0,1) > 4)
    { self.win1.focus();
    }
  }
//history.go(0);
}

// The check_prereq function ensures that prerequisite data is filled before a pop-up window opens.
function check_prereq(current_field) {
	if (current_field=="as_county") {
		if (document.forms[1].as_state.selectedIndex <= 0){
			alert("Please select a state before selecting a county.");
			document.forms[1].as_state.focus();
			return false;
		}
		else openWin('state');
	}
	return false;
}
//======================================================
// Function Name : adjust_width_n()
// Author : Ganesh Thadkamalla/Blythe Norris
//==========================================================
function adjust_width_n(D_LIST, delim, dwl, fp_name, fp_flag)
{
var     D_WIDTH_LIST = new Array();
var 	column_list = new Array();
var	desired_width;
var	current_line;
var     lv_dwl = dwl;
var     lv_dw;
var      i = 0;
var   updated_line;
var   firstLine = 0;

if (D_LIST.value != 'DUMMY')
{


  // creating D_WIDTH_LIST[] based on dwl string example "5~10~60~23~5"
  while (lv_dwl.indexOf(delim) != -1 )
  {
    D_WIDTH_LIST[i] = lv_dwl.substring(0,lv_dwl.indexOf(delim));
    lv_dwl = lv_dwl.substring(lv_dwl.indexOf(delim)+1,lv_dwl.length);
    i = i+1;
    D_WIDTH_LIST[i] = lv_dwl;
  }
  //
  // to make first row Select all and keep it selected if selected.
  //
if (fp_flag == 'Y')
{   firstLine = 1;
    if (D_LIST.options[0].selected)
    {
    D_LIST.options[0].text = 'Select All';
    D_LIST.options[0].selected = 'TRUE';}
    else
    {D_LIST.options[0].text = 'Select All';}
}
//For each row in the D_LIST process for each of the row breakdown into column_list[].

for(var i=firstLine; i < D_LIST.length; i++)
	{
	if(D_LIST.options[i].text.indexOf(delim) >= 0)
	{
	current_line = D_LIST.options[i].text;
 	for (var j=0; j < D_WIDTH_LIST.length; j++)
	{
	  if(current_line.indexOf(delim) >= 0)
	  {
   	    column_list[j] = current_line.substring(0,current_line.indexOf(delim));
    	    current_line = current_line.substring(current_line.indexOf(delim)+1,current_line.length);
	  }
	  else
	  {
	    column_list[j] = current_line;
	  }
	}
	//
        //adding spaces after each of the column_list to the desired width length
	//
      for(var k = 0; k < column_list.length; k++)
	{
	  desired_width = D_WIDTH_LIST[k];
	  for(var j = column_list[k].length; j < desired_width; j++)
	   {
	     column_list[k] = column_list[k] + ' ';
	   }
	}
	//
	// Formulating the string with spaces.
	//
	for(var l = 0; l < column_list.length; l++)
	{
	if (l == 0)
	{updated_line = column_list[l];}
 	else
 	{updated_line = updated_line + ' ' +column_list[l];}
	}
	  if (D_LIST.options[i].selected)
          { D_LIST.options[i].text = updated_line;
             D_LIST.options[i].selected = 'TRUE';
	  }
          else
          { D_LIST.options[i].text = updated_line;
	  }

}//end of if loop evaluating if D_List delim exists.
}// end of D_LIST FOR loop
return D_LIST;
history.go(0);
}//end of if loop  evaluating if no D_List exists.
}//end of function.
//======================================================
// Function Name :  close_onclick()  Author : Joseph Wilson
//==========================================================
//close browser window
function Close_Onclick() {
	parent.close();
}
//======================================================
// Function Name : DaysInMonth()  Author : Joseph Wilson
//==========================================================
//function for returning how many days there are in a month including leap years
function DaysInMonth(WhichMonth, WhichYear)
{
  var DaysInMonth = 31;
  if (WhichMonth == "APR" || WhichMonth == "JUN" || WhichMonth == "SEP" || WhichMonth == "NOV") DaysInMonth = 30;
  if (WhichMonth == "FEB" && (WhichYear/4) != Math.floor(WhichYear/4))	DaysInMonth = 28;
  if (WhichMonth == "FEB" && (WhichYear/4) == Math.floor(WhichYear/4))	DaysInMonth = 29;
  if (WhichMonth == "FEB" && (WhichYear/1900) == 1) DaysInMonth = 28;
  return DaysInMonth;
}
//======================================================
// Function Name : ChangeOptionDays()  Author : Joseph Wilson
//==========================================================
//function to change the available days in a months
function ChangeOptionDays(Group,Which)
{
  DaysObject = eval("document.forms[1]."+Group+"_DD"+Which);
  MonthObject = eval("document.forms[1]."+Group+"_MON"+Which);
  YearObject = eval("document.forms[1]."+Group+"_YYYY"+Which);

  Month = MonthObject[MonthObject.selectedIndex].text;
  Year = YearObject[YearObject.selectedIndex].text;

  DaysForThisSelection = DaysInMonth(Month, Year);
  CurrentDaysInSelection = DaysObject.length;

  v_dummy = 0;

  if (DaysObject.options[0].text == '--')
	{
		CurrentDaysInSelection--;
		v_dummy = -1;
	};
  if (CurrentDaysInSelection > DaysForThisSelection)
  {	
    	for (i=0; i<(CurrentDaysInSelection-DaysForThisSelection); i++)
    	{
      	DaysObject.options[DaysObject.options.length - 1] = null;
    	}
  };
  if (DaysForThisSelection > CurrentDaysInSelection)
  {	
    	for (i=0; i<(DaysForThisSelection-CurrentDaysInSelection); i++)
    	{
      	//NewOption = new Option(DaysObject.options.length + v_dummy + 1);
      	//DaysObject.add(NewOption);
		DaysObject.options[DaysObject.options.length] = new Option(DaysObject.options.length + v_dummy + 1);
    	};
  };
  //if (DaysObject.selectedIndex < 0) DaysObject.selectedIndex == 0;
  if (DaysObject.selectedIndex < 0 || (DaysObject.selectedIndex==0 && v_dummy==-1))
  {
	if (v_dummy==0) {
	DaysObject.options[0].selected = true;
	}
	else
	{
	DaysObject.options[1].selected = true;
	//if (YearObject.selectedIndex <1)  YearObject.options[1].selected = true;
	//if (MonthObject.selectedIndex <1)  MonthObject.options[1].selected = true;
	}
  }
}
//===========================================================
//Function Name : dateRangeValidate() Author : Thieu Nguyen
//===========================================================
function dateRangeValidate(){
   booDate = true;
    var monthFr = new Array(document.forms[1].FROM_MON1.selectedIndex,document.forms[1].FROM_MON2.selectedIndex,document.forms[1].FROM_MON3.selectedIndex,document.forms[1].FROM_MON4.selectedIndex);
    var monthEn = new Array(document.forms[1].END_MON1.selectedIndex,document.forms[1].END_MON2.selectedIndex,document.forms[1].END_MON3.selectedIndex,document.forms[1].END_MON4.selectedIndex);
    
    dateF1 = new Date(document.forms[1].FROM_YYYY1.selectedIndex + 1900,monthFr[0],document.forms[1].FROM_DD1.selectedIndex + 1)
    dateE1 = new Date(document.forms[1].END_YYYY1.selectedIndex + 1900,monthEn[0],document.forms[1].END_DD1.selectedIndex + 1)
    
    dateF2 = new Date(document.forms[1].FROM_YYYY2.selectedIndex + 1900,monthFr[1],document.forms[1].FROM_DD2.selectedIndex + 1)
    dateE2 = new Date(document.forms[1].END_YYYY2.selectedIndex + 1900,monthEn[1],document.forms[1].END_DD2.selectedIndex + 1)
    
    dateF3 = new Date(document.forms[1].FROM_YYYY3.selectedIndex + 1900,monthFr[2],document.forms[1].FROM_DD3.selectedIndex + 1)
    dateE3 = new Date(document.forms[1].END_YYYY3.selectedIndex + 1900,monthEn[2],document.forms[1].END_DD3.selectedIndex + 1)
    
    dateF4 = new Date(document.forms[1].FROM_YYYY4.selectedIndex + 1900,monthFr[3],document.forms[1].FROM_DD4.selectedIndex + 1)
    dateE4 = new Date(document.forms[1].END_YYYY4.selectedIndex + 1900,monthEn[3],document.forms[1].END_DD4.selectedIndex + 1)
    
     if(dateF1 > dateE1 || dateF2 > dateE2 || dateF3 > dateE3 || dateF4 > dateE4){
	alert('Date range is invalid--- From date is later than To date.');
	booDate = false;
	}
    return booDate;
}
//======================================================
// Function Name : completeDateValidate()  Author : Joseph Wilson
//==========================================================
//function to block submission of partial dates
function completeDateValidate() {
	var booPass = true;
	if (document.forms[1].FROM_YYYY2.selectedIndex>0 || document.forms[1].FROM_MON2.selectedIndex>0 || document.forms[1].FROM_DD2.selectedIndex>0) {
		if (document.forms[1].FROM_YYYY2.selectedIndex<1 || document.forms[1].FROM_MON2.selectedIndex<1 || document.forms[1].FROM_DD2.selectedIndex<1) {
			booPass = false;
		}
	}
	if (document.forms[1].FROM_YYYY3.selectedIndex>0 || document.forms[1].FROM_MON3.selectedIndex>0 || document.forms[1].FROM_DD3.selectedIndex>0) {
		if (document.forms[1].FROM_YYYY3.selectedIndex<1 || document.forms[1].FROM_MON3.selectedIndex<1 || document.forms[1].FROM_DD3.selectedIndex<1) {
			booPass = false;
		}
	}
	if (document.forms[1].FROM_YYYY4.selectedIndex>0 || document.forms[1].FROM_MON4.selectedIndex>0 || document.forms[1].FROM_DD4.selectedIndex>0) {
		if (document.forms[1].FROM_YYYY4.selectedIndex<1 || document.forms[1].FROM_MON4.selectedIndex<1 || document.forms[1].FROM_DD4.selectedIndex<1) {
			booPass = false;
		}
	}
	if (document.forms[1].END_YYYY2.selectedIndex>0 || document.forms[1].END_MON2.selectedIndex>0 || document.forms[1].END_DD2.selectedIndex>0) {
		if (document.forms[1].END_YYYY2.selectedIndex<1 || document.forms[1].END_MON2.selectedIndex<1 || document.forms[1].END_DD2.selectedIndex<1) {
			booPass = false;
		}
	}
	if (document.forms[1].END_YYYY3.selectedIndex>0 || document.forms[1].END_MON3.selectedIndex>0 || document.forms[1].END_DD3.selectedIndex>0) {
		if (document.forms[1].END_YYYY3.selectedIndex<1 || document.forms[1].END_MON3.selectedIndex<1 || document.forms[1].END_DD3.selectedIndex<1) {
			booPass = false;
		}
	}
	if (document.forms[1].END_YYYY4.selectedIndex>0 || document.forms[1].END_MON4.selectedIndex>0 || document.forms[1].END_DD4.selectedIndex>0) {
		if (document.forms[1].END_YYYY4.selectedIndex<1 || document.forms[1].END_MON4.selectedIndex<1 || document.forms[1].END_DD4.selectedIndex<1) {
			booPass = false;
		}
	}
	if (booPass == false)  alert('Invalid date-- Partial date entrys can not be processed.'); 
	return booPass;
}